/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.List;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.dom.OnElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDefine {
    private String m_name;
    private List<String> m_includes = Lists.newArrayList();

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        boolean hasElements = CollectionUtils.hasElements(this.m_includes);
        if (hasElements) {
            xsb.push("define", "name", this.m_name);
        }
        for (String s : this.m_includes) {
            xsb.addEmptyElement("include", "name", s);
        }
        if (hasElements) {
            xsb.pop("define");
        }
        return xsb.toXML();
    }

    @OnElement(tag="include", attributes={"name"})
    public void onElement(String name) {
        this.m_includes.add(name);
    }

    public List<String> getIncludes() {
        return this.m_includes;
    }
}

