// Package account implements the Azure ARM Account service API version
// 2015-10-01-preview.
//
// Creates an Azure Data Lake Store account management client.
package account

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

const (
	// APIVersion is the version of the Account
	APIVersion = "2015-10-01-preview"

	// DefaultBaseURI is the default URI used for the service Account
	DefaultBaseURI = "https://management.azure.com"
)

// ManagementClient is the base client for Account.
type ManagementClient struct {
	autorest.Client
	BaseURI        string
	APIVersion     string
	SubscriptionID string
}

// New creates an instance of the ManagementClient client.
func New(subscriptionID string) ManagementClient {
	return NewWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWithBaseURI creates an instance of the ManagementClient client.
func NewWithBaseURI(baseURI string, subscriptionID string) ManagementClient {
	return ManagementClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		APIVersion:     APIVersion,
		SubscriptionID: subscriptionID,
	}
}

// Create creates the specified Data Lake Store account. This method may poll
// for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account. name is the name of the Data Lake Store account
// to create. parameters is parameters supplied to create the Data Lake Store
// account.
func (client ManagementClient) Create(resourceGroupName string, name string, parameters DataLakeStoreAccount, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreatePreparer(resourceGroupName, name, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "Create", nil, "Failure preparing request")
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "Create", resp, "Failure sending request")
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "Create", resp, "Failure responding to request")
	}

	return
}

// CreatePreparer prepares the Create request.
func (client ManagementClient) CreatePreparer(resourceGroupName string, name string, parameters DataLakeStoreAccount, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{name}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) CreateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client ManagementClient) CreateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusCreated, http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateOrUpdateFirewallRule creates or updates the specified firewall rule.
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account. accountName is the name of the Data Lake Store
// account to which to add the firewall rule. name is the name of the
// firewall rule to create or update. parameters is parameters supplied to
// create the create firewall rule.
func (client ManagementClient) CreateOrUpdateFirewallRule(resourceGroupName string, accountName string, name string, parameters FirewallRule) (result FirewallRule, err error) {
	req, err := client.CreateOrUpdateFirewallRulePreparer(resourceGroupName, accountName, name, parameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "CreateOrUpdateFirewallRule", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateFirewallRuleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "CreateOrUpdateFirewallRule", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateFirewallRuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "CreateOrUpdateFirewallRule", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateFirewallRulePreparer prepares the CreateOrUpdateFirewallRule request.
func (client ManagementClient) CreateOrUpdateFirewallRulePreparer(resourceGroupName string, accountName string, name string, parameters FirewallRule) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{name}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateFirewallRuleSender sends the CreateOrUpdateFirewallRule request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) CreateOrUpdateFirewallRuleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateFirewallRuleResponder handles the response to the CreateOrUpdateFirewallRule request. The method always
// closes the http.Response Body.
func (client ManagementClient) CreateOrUpdateFirewallRuleResponder(resp *http.Response) (result FirewallRule, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the specified Data Lake Store account. This method may poll
// for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account. accountName is the name of the Data Lake Store
// account to delete.
func (client ManagementClient) Delete(resourceGroupName string, accountName string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.DeletePreparer(resourceGroupName, accountName, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "Delete", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "Delete", resp, "Failure sending request")
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ManagementClient) DeletePreparer(resourceGroupName string, accountName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ManagementClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound, http.StatusNoContent, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteFirewallRule deletes the specified firewall rule from the specified
// Data Lake Store account
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account. accountName is the name of the Data Lake Store
// account from which to delete the firewall rule. firewallRuleName is the
// name of the firewall rule to delete.
func (client ManagementClient) DeleteFirewallRule(resourceGroupName string, accountName string, firewallRuleName string) (result autorest.Response, err error) {
	req, err := client.DeleteFirewallRulePreparer(resourceGroupName, accountName, firewallRuleName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "DeleteFirewallRule", nil, "Failure preparing request")
	}

	resp, err := client.DeleteFirewallRuleSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "DeleteFirewallRule", resp, "Failure sending request")
	}

	result, err = client.DeleteFirewallRuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "DeleteFirewallRule", resp, "Failure responding to request")
	}

	return
}

// DeleteFirewallRulePreparer prepares the DeleteFirewallRule request.
func (client ManagementClient) DeleteFirewallRulePreparer(resourceGroupName string, accountName string, firewallRuleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"firewallRuleName":  autorest.Encode("path", firewallRuleName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteFirewallRuleSender sends the DeleteFirewallRule request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) DeleteFirewallRuleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteFirewallRuleResponder handles the response to the DeleteFirewallRule request. The method always
// closes the http.Response Body.
func (client ManagementClient) DeleteFirewallRuleResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the specified Data Lake Store account.
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account. accountName is the name of the Data Lake Store
// account to retrieve.
func (client ManagementClient) Get(resourceGroupName string, accountName string) (result DataLakeStoreAccount, err error) {
	req, err := client.GetPreparer(resourceGroupName, accountName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "Get", nil, "Failure preparing request")
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "Get", resp, "Failure sending request")
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ManagementClient) GetPreparer(resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ManagementClient) GetResponder(resp *http.Response) (result DataLakeStoreAccount, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFirewallRule gets the specified Data Lake Store firewall rule.
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account. accountName is the name of the Data Lake Store
// account from which to get the firewall rule. firewallRuleName is the name
// of the firewall rule to retrieve.
func (client ManagementClient) GetFirewallRule(resourceGroupName string, accountName string, firewallRuleName string) (result FirewallRule, err error) {
	req, err := client.GetFirewallRulePreparer(resourceGroupName, accountName, firewallRuleName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "GetFirewallRule", nil, "Failure preparing request")
	}

	resp, err := client.GetFirewallRuleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "GetFirewallRule", resp, "Failure sending request")
	}

	result, err = client.GetFirewallRuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "GetFirewallRule", resp, "Failure responding to request")
	}

	return
}

// GetFirewallRulePreparer prepares the GetFirewallRule request.
func (client ManagementClient) GetFirewallRulePreparer(resourceGroupName string, accountName string, firewallRuleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"firewallRuleName":  autorest.Encode("path", firewallRuleName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetFirewallRuleSender sends the GetFirewallRule request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) GetFirewallRuleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetFirewallRuleResponder handles the response to the GetFirewallRule request. The method always
// closes the http.Response Body.
func (client ManagementClient) GetFirewallRuleResponder(resp *http.Response) (result FirewallRule, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists the Data Lake Store accounts within the subscription. The
// response includes a link to the next page of results, if any.
//
// filter is oData filter. Optional. top is the number of items to return.
// Optional. skip is the number of items to skip over before returning
// elements. Optional. expand is oData expansion. Expand related resources in
// line with the retrieved resources, e.g. Categories/$expand=Products would
// expand Product data in line with each Category entry. Optional.
// selectParameter is oData Select statement. Limits the properties on each
// entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional. orderby is orderBy
// clause. One or more comma-separated expressions with an optional "asc"
// (the default) or "desc" depending on the order you'd like the values
// sorted, e.g. Categories?$orderby=CategoryName desc. Optional. count is the
// Boolean value of true or false to request a count of the matching
// resources included with the resources in the response, e.g.
// Categories?$count=true. Optional. search is a free form search. A
// free-text search expression to match for whether a particular entry should
// be included in the feed, e.g. Categories?$search=blue OR green. Optional.
// formatParameter is the desired return format. Return the response in
// particular formatxii without access to request headers for standard
// content-type negotiation (e.g Orders?$format=json). Optional.
func (client ManagementClient) List(filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeStoreAccountListResult, err error) {
	req, err := client.ListPreparer(filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "List", nil, "Failure preparing request")
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "List", resp, "Failure sending request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ManagementClient) ListPreparer(filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}
	if len(formatParameter) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeStore/accounts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ManagementClient) ListResponder(resp *http.Response) (result DataLakeStoreAccountListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client ManagementClient) ListNextResults(lastResults DataLakeStoreAccountListResult) (result DataLakeStoreAccountListResult, err error) {
	req, err := lastResults.DataLakeStoreAccountListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "List", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "List", resp, "Failure sending next results request request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "List", resp, "Failure responding to next results request request")
	}

	return
}

// ListByResourceGroup lists the Data Lake Store accounts within a specific
// resource group. The response includes a link to the next page of results,
// if any.
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account(s). filter is oData filter. Optional. top is the
// number of items to return. Optional. skip is the number of items to skip
// over before returning elements. Optional. expand is oData expansion.
// Expand related resources in line with the retrieved resources, e.g.
// Categories/$expand=Products would expand Product data in line with each
// Category entry. Optional. selectParameter is oData Select statement.
// Limits the properties on each entry to just those requested, e.g.
// Categories?$select=CategoryName,Description. Optional. orderby is orderBy
// clause. One or more comma-separated expressions with an optional "asc"
// (the default) or "desc" depending on the order you'd like the values
// sorted, e.g. Categories?$orderby=CategoryName desc. Optional. count is a
// Boolean value of true or false to request a count of the matching
// resources included with the resources in the response, e.g.
// Categories?$count=true. Optional. search is a free form search. A
// free-text search expression to match for whether a particular entry should
// be included in the feed, e.g. Categories?$search=blue OR green. Optional.
// formatParameter is the desired return format. Return the response in
// particular formatxii without access to request headers for standard
// content-type negotiation (e.g Orders?$format=json). Optional.
func (client ManagementClient) ListByResourceGroup(resourceGroupName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (result DataLakeStoreAccountListResult, err error) {
	req, err := client.ListByResourceGroupPreparer(resourceGroupName, filter, top, skip, expand, selectParameter, orderby, count, search, formatParameter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "ListByResourceGroup", nil, "Failure preparing request")
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "ListByResourceGroup", resp, "Failure sending request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client ManagementClient) ListByResourceGroupPreparer(resourceGroupName string, filter string, top *int32, skip *int32, expand string, selectParameter string, orderby string, count *bool, search string, formatParameter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}
	if len(formatParameter) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client ManagementClient) ListByResourceGroupResponder(resp *http.Response) (result DataLakeStoreAccountListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client ManagementClient) ListByResourceGroupNextResults(lastResults DataLakeStoreAccountListResult) (result DataLakeStoreAccountListResult, err error) {
	req, err := lastResults.DataLakeStoreAccountListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "ListByResourceGroup", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "ListByResourceGroup", resp, "Failure sending next results request request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "ListByResourceGroup", resp, "Failure responding to next results request request")
	}

	return
}

// ListFirewallRules lists the Data Lake Store firewall rules within the
// specified Data Lake Store account.
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account. accountName is the name of the Data Lake Store
// account from which to get the firewall rules.
func (client ManagementClient) ListFirewallRules(resourceGroupName string, accountName string) (result DataLakeStoreFirewallRuleListResult, err error) {
	req, err := client.ListFirewallRulesPreparer(resourceGroupName, accountName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "ListFirewallRules", nil, "Failure preparing request")
	}

	resp, err := client.ListFirewallRulesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "ListFirewallRules", resp, "Failure sending request")
	}

	result, err = client.ListFirewallRulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "ListFirewallRules", resp, "Failure responding to request")
	}

	return
}

// ListFirewallRulesPreparer prepares the ListFirewallRules request.
func (client ManagementClient) ListFirewallRulesPreparer(resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListFirewallRulesSender sends the ListFirewallRules request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) ListFirewallRulesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListFirewallRulesResponder handles the response to the ListFirewallRules request. The method always
// closes the http.Response Body.
func (client ManagementClient) ListFirewallRulesResponder(resp *http.Response) (result DataLakeStoreFirewallRuleListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFirewallRulesNextResults retrieves the next set of results, if any.
func (client ManagementClient) ListFirewallRulesNextResults(lastResults DataLakeStoreFirewallRuleListResult) (result DataLakeStoreFirewallRuleListResult, err error) {
	req, err := lastResults.DataLakeStoreFirewallRuleListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "ListFirewallRules", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListFirewallRulesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "ListFirewallRules", resp, "Failure sending next results request request")
	}

	result, err = client.ListFirewallRulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "ListFirewallRules", resp, "Failure responding to next results request request")
	}

	return
}

// Update updates the specified Data Lake Store account information. This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and
// any outstanding HTTP requests.
//
// resourceGroupName is the name of the Azure resource group that contains the
// Data Lake Store account. name is the name of the Data Lake Store account
// to update. parameters is parameters supplied to update the Data Lake Store
// account.
func (client ManagementClient) Update(resourceGroupName string, name string, parameters DataLakeStoreAccount, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.UpdatePreparer(resourceGroupName, name, parameters, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "Update", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "account.ManagementClient", "Update", resp, "Failure sending request")
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "account.ManagementClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ManagementClient) UpdatePreparer(resourceGroupName string, name string, parameters DataLakeStoreAccount, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{name}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ManagementClient) UpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByClosing())
	result.Response = resp
	return
}
