// { dg-do run { target c++11 } }
// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
//
// Copyright (C) 2016-2023 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  assoc_laguerre
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <tr1/cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>

// Test data for n=0, m=0.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data001[11] =
{
  { 1.0000000000000000, 0, 0, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  20.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  30.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  50.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  60.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  70.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  80.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  100.00000000000000, 0.0 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for n=0, m=1.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data002[11] =
{
  { 1.0000000000000000, 0, 1, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  20.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  30.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  50.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  60.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  70.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  80.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 1, 
	  100.00000000000000, 0.0 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for n=0, m=2.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data003[11] =
{
  { 1.0000000000000000, 0, 2, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  20.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  30.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  50.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  60.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  70.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  80.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 2, 
	  100.00000000000000, 0.0 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for n=0, m=5.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data004[11] =
{
  { 1.0000000000000000, 0, 5, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  20.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  30.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  50.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  60.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  70.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  80.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 5, 
	  100.00000000000000, 0.0 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for n=0, m=10.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data005[11] =
{
  { 1.0000000000000000, 0, 10, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  20.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  30.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  50.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  60.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  70.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  80.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 10, 
	  100.00000000000000, 0.0 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for n=0, m=20.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data006[11] =
{
  { 1.0000000000000000, 0, 20, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  20.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  30.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  50.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  60.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  70.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  80.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 20, 
	  100.00000000000000, 0.0 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for n=0, m=50.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data007[11] =
{
  { 1.0000000000000000, 0, 50, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  20.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  30.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  50.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  60.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  70.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  80.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 50, 
	  100.00000000000000, 0.0 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for n=0, m=100.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data008[11] =
{
  { 1.0000000000000000, 0, 100, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  20.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  30.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  50.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  60.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  70.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  80.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 0, 100, 
	  100.00000000000000, 0.0 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for n=1, m=0.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data009[11] =
{
  { 1.0000000000000000, 1, 0, 
	  0.0000000000000000, 0.0 },
  { -9.0000000000000000, 1, 0, 
	  10.000000000000000, 0.0 },
  { -19.000000000000000, 1, 0, 
	  20.000000000000000, 0.0 },
  { -29.000000000000000, 1, 0, 
	  30.000000000000000, 0.0 },
  { -39.000000000000000, 1, 0, 
	  40.000000000000000, 0.0 },
  { -49.000000000000000, 1, 0, 
	  50.000000000000000, 0.0 },
  { -59.000000000000000, 1, 0, 
	  60.000000000000000, 0.0 },
  { -69.000000000000000, 1, 0, 
	  70.000000000000000, 0.0 },
  { -79.000000000000000, 1, 0, 
	  80.000000000000000, 0.0 },
  { -89.000000000000000, 1, 0, 
	  90.000000000000000, 0.0 },
  { -99.000000000000000, 1, 0, 
	  100.00000000000000, 0.0 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for n=1, m=1.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data010[11] =
{
  { 2.0000000000000000, 1, 1, 
	  0.0000000000000000, 0.0 },
  { -8.0000000000000000, 1, 1, 
	  10.000000000000000, 0.0 },
  { -18.000000000000000, 1, 1, 
	  20.000000000000000, 0.0 },
  { -28.000000000000000, 1, 1, 
	  30.000000000000000, 0.0 },
  { -38.000000000000000, 1, 1, 
	  40.000000000000000, 0.0 },
  { -48.000000000000000, 1, 1, 
	  50.000000000000000, 0.0 },
  { -58.000000000000000, 1, 1, 
	  60.000000000000000, 0.0 },
  { -68.000000000000000, 1, 1, 
	  70.000000000000000, 0.0 },
  { -78.000000000000000, 1, 1, 
	  80.000000000000000, 0.0 },
  { -88.000000000000000, 1, 1, 
	  90.000000000000000, 0.0 },
  { -98.000000000000000, 1, 1, 
	  100.00000000000000, 0.0 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for n=1, m=2.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data011[11] =
{
  { 3.0000000000000000, 1, 2, 
	  0.0000000000000000, 0.0 },
  { -7.0000000000000000, 1, 2, 
	  10.000000000000000, 0.0 },
  { -17.000000000000000, 1, 2, 
	  20.000000000000000, 0.0 },
  { -27.000000000000000, 1, 2, 
	  30.000000000000000, 0.0 },
  { -37.000000000000000, 1, 2, 
	  40.000000000000000, 0.0 },
  { -47.000000000000000, 1, 2, 
	  50.000000000000000, 0.0 },
  { -57.000000000000000, 1, 2, 
	  60.000000000000000, 0.0 },
  { -67.000000000000000, 1, 2, 
	  70.000000000000000, 0.0 },
  { -77.000000000000000, 1, 2, 
	  80.000000000000000, 0.0 },
  { -87.000000000000000, 1, 2, 
	  90.000000000000000, 0.0 },
  { -97.000000000000000, 1, 2, 
	  100.00000000000000, 0.0 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for n=1, m=5.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data012[11] =
{
  { 6.0000000000000000, 1, 5, 
	  0.0000000000000000, 0.0 },
  { -4.0000000000000000, 1, 5, 
	  10.000000000000000, 0.0 },
  { -14.000000000000000, 1, 5, 
	  20.000000000000000, 0.0 },
  { -24.000000000000000, 1, 5, 
	  30.000000000000000, 0.0 },
  { -34.000000000000000, 1, 5, 
	  40.000000000000000, 0.0 },
  { -44.000000000000000, 1, 5, 
	  50.000000000000000, 0.0 },
  { -54.000000000000000, 1, 5, 
	  60.000000000000000, 0.0 },
  { -64.000000000000000, 1, 5, 
	  70.000000000000000, 0.0 },
  { -74.000000000000000, 1, 5, 
	  80.000000000000000, 0.0 },
  { -84.000000000000000, 1, 5, 
	  90.000000000000000, 0.0 },
  { -94.000000000000000, 1, 5, 
	  100.00000000000000, 0.0 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for n=1, m=10.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data013[11] =
{
  { 11.000000000000000, 1, 10, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 1, 10, 
	  10.000000000000000, 0.0 },
  { -9.0000000000000000, 1, 10, 
	  20.000000000000000, 0.0 },
  { -19.000000000000000, 1, 10, 
	  30.000000000000000, 0.0 },
  { -29.000000000000000, 1, 10, 
	  40.000000000000000, 0.0 },
  { -39.000000000000000, 1, 10, 
	  50.000000000000000, 0.0 },
  { -49.000000000000000, 1, 10, 
	  60.000000000000000, 0.0 },
  { -59.000000000000000, 1, 10, 
	  70.000000000000000, 0.0 },
  { -69.000000000000000, 1, 10, 
	  80.000000000000000, 0.0 },
  { -79.000000000000000, 1, 10, 
	  90.000000000000000, 0.0 },
  { -89.000000000000000, 1, 10, 
	  100.00000000000000, 0.0 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for n=1, m=20.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data014[11] =
{
  { 21.000000000000000, 1, 20, 
	  0.0000000000000000, 0.0 },
  { 11.000000000000000, 1, 20, 
	  10.000000000000000, 0.0 },
  { 1.0000000000000000, 1, 20, 
	  20.000000000000000, 0.0 },
  { -9.0000000000000000, 1, 20, 
	  30.000000000000000, 0.0 },
  { -19.000000000000000, 1, 20, 
	  40.000000000000000, 0.0 },
  { -29.000000000000000, 1, 20, 
	  50.000000000000000, 0.0 },
  { -39.000000000000000, 1, 20, 
	  60.000000000000000, 0.0 },
  { -49.000000000000000, 1, 20, 
	  70.000000000000000, 0.0 },
  { -59.000000000000000, 1, 20, 
	  80.000000000000000, 0.0 },
  { -69.000000000000000, 1, 20, 
	  90.000000000000000, 0.0 },
  { -79.000000000000000, 1, 20, 
	  100.00000000000000, 0.0 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for n=1, m=50.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data015[11] =
{
  { 51.000000000000000, 1, 50, 
	  0.0000000000000000, 0.0 },
  { 41.000000000000000, 1, 50, 
	  10.000000000000000, 0.0 },
  { 31.000000000000000, 1, 50, 
	  20.000000000000000, 0.0 },
  { 21.000000000000000, 1, 50, 
	  30.000000000000000, 0.0 },
  { 11.000000000000000, 1, 50, 
	  40.000000000000000, 0.0 },
  { 1.0000000000000000, 1, 50, 
	  50.000000000000000, 0.0 },
  { -9.0000000000000000, 1, 50, 
	  60.000000000000000, 0.0 },
  { -19.000000000000000, 1, 50, 
	  70.000000000000000, 0.0 },
  { -29.000000000000000, 1, 50, 
	  80.000000000000000, 0.0 },
  { -39.000000000000000, 1, 50, 
	  90.000000000000000, 0.0 },
  { -49.000000000000000, 1, 50, 
	  100.00000000000000, 0.0 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for n=1, m=100.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data016[11] =
{
  { 101.00000000000000, 1, 100, 
	  0.0000000000000000, 0.0 },
  { 91.000000000000000, 1, 100, 
	  10.000000000000000, 0.0 },
  { 81.000000000000000, 1, 100, 
	  20.000000000000000, 0.0 },
  { 71.000000000000000, 1, 100, 
	  30.000000000000000, 0.0 },
  { 61.000000000000000, 1, 100, 
	  40.000000000000000, 0.0 },
  { 51.000000000000000, 1, 100, 
	  50.000000000000000, 0.0 },
  { 41.000000000000000, 1, 100, 
	  60.000000000000000, 0.0 },
  { 31.000000000000000, 1, 100, 
	  70.000000000000000, 0.0 },
  { 21.000000000000000, 1, 100, 
	  80.000000000000000, 0.0 },
  { 11.000000000000000, 1, 100, 
	  90.000000000000000, 0.0 },
  { 1.0000000000000000, 1, 100, 
	  100.00000000000000, 0.0 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for n=2, m=0.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data017[11] =
{
  { 1.0000000000000000, 2, 0, 
	  0.0000000000000000, 0.0 },
  { 31.000000000000000, 2, 0, 
	  10.000000000000000, 0.0 },
  { 161.00000000000000, 2, 0, 
	  20.000000000000000, 0.0 },
  { 391.00000000000000, 2, 0, 
	  30.000000000000000, 0.0 },
  { 721.00000000000000, 2, 0, 
	  40.000000000000000, 0.0 },
  { 1151.0000000000000, 2, 0, 
	  50.000000000000000, 0.0 },
  { 1681.0000000000000, 2, 0, 
	  60.000000000000000, 0.0 },
  { 2311.0000000000000, 2, 0, 
	  70.000000000000000, 0.0 },
  { 3041.0000000000000, 2, 0, 
	  80.000000000000000, 0.0 },
  { 3871.0000000000000, 2, 0, 
	  90.000000000000000, 0.0 },
  { 4801.0000000000000, 2, 0, 
	  100.00000000000000, 0.0 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for n=2, m=1.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data018[11] =
{
  { 3.0000000000000000, 2, 1, 
	  0.0000000000000000, 0.0 },
  { 23.000000000000000, 2, 1, 
	  10.000000000000000, 0.0 },
  { 143.00000000000000, 2, 1, 
	  20.000000000000000, 0.0 },
  { 363.00000000000000, 2, 1, 
	  30.000000000000000, 0.0 },
  { 683.00000000000000, 2, 1, 
	  40.000000000000000, 0.0 },
  { 1103.0000000000000, 2, 1, 
	  50.000000000000000, 0.0 },
  { 1623.0000000000000, 2, 1, 
	  60.000000000000000, 0.0 },
  { 2243.0000000000000, 2, 1, 
	  70.000000000000000, 0.0 },
  { 2963.0000000000000, 2, 1, 
	  80.000000000000000, 0.0 },
  { 3783.0000000000000, 2, 1, 
	  90.000000000000000, 0.0 },
  { 4703.0000000000000, 2, 1, 
	  100.00000000000000, 0.0 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for n=2, m=2.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data019[11] =
{
  { 6.0000000000000000, 2, 2, 
	  0.0000000000000000, 0.0 },
  { 16.000000000000000, 2, 2, 
	  10.000000000000000, 0.0 },
  { 126.00000000000000, 2, 2, 
	  20.000000000000000, 0.0 },
  { 336.00000000000000, 2, 2, 
	  30.000000000000000, 0.0 },
  { 646.00000000000000, 2, 2, 
	  40.000000000000000, 0.0 },
  { 1056.0000000000000, 2, 2, 
	  50.000000000000000, 0.0 },
  { 1566.0000000000000, 2, 2, 
	  60.000000000000000, 0.0 },
  { 2176.0000000000000, 2, 2, 
	  70.000000000000000, 0.0 },
  { 2886.0000000000000, 2, 2, 
	  80.000000000000000, 0.0 },
  { 3696.0000000000000, 2, 2, 
	  90.000000000000000, 0.0 },
  { 4606.0000000000000, 2, 2, 
	  100.00000000000000, 0.0 },
};
const double toler019 = 2.5000000000000020e-13;

// Test data for n=2, m=5.
// max(|f - f_GSL|): 4.5519144009631418e-15 at index 1
// max(|f - f_GSL| / |f_GSL|): 4.5519144009631623e-15
// mean(f - f_GSL): 4.1381040008755832e-16
// variance(f - f_GSL): 1.8836295194268761e-32
// stddev(f - f_GSL): 1.3724538314372823e-16
const testcase_assoc_laguerre<double>
data020[11] =
{
  { 21.000000000000000, 2, 5, 
	  0.0000000000000000, 0.0 },
  { 0.99999999999999545, 2, 5, 
	  10.000000000000000, 0.0 },
  { 81.000000000000000, 2, 5, 
	  20.000000000000000, 0.0 },
  { 261.00000000000000, 2, 5, 
	  30.000000000000000, 0.0 },
  { 541.00000000000000, 2, 5, 
	  40.000000000000000, 0.0 },
  { 921.00000000000000, 2, 5, 
	  50.000000000000000, 0.0 },
  { 1401.0000000000000, 2, 5, 
	  60.000000000000000, 0.0 },
  { 1981.0000000000000, 2, 5, 
	  70.000000000000000, 0.0 },
  { 2661.0000000000000, 2, 5, 
	  80.000000000000000, 0.0 },
  { 3441.0000000000000, 2, 5, 
	  90.000000000000000, 0.0 },
  { 4321.0000000000000, 2, 5, 
	  100.00000000000000, 0.0 },
};
const double toler020 = 2.5000000000000020e-13;

// Test data for n=2, m=10.
// max(|f - f_GSL|): 3.5527136788005009e-14 at index 2
// max(|f - f_GSL| / |f_GSL|): 2.4424906541753385e-15
// mean(f - f_GSL): 4.1179181277005809e-15
// variance(f - f_GSL): 1.8652974677089562e-30
// stddev(f - f_GSL): 1.3657589346985639e-15
const testcase_assoc_laguerre<double>
data021[11] =
{
  { 66.000000000000000, 2, 10, 
	  0.0000000000000000, 0.0 },
  { -4.0000000000000098, 2, 10, 
	  10.000000000000000, 0.0 },
  { 25.999999999999964, 2, 10, 
	  20.000000000000000, 0.0 },
  { 156.00000000000000, 2, 10, 
	  30.000000000000000, 0.0 },
  { 386.00000000000000, 2, 10, 
	  40.000000000000000, 0.0 },
  { 716.00000000000000, 2, 10, 
	  50.000000000000000, 0.0 },
  { 1146.0000000000000, 2, 10, 
	  60.000000000000000, 0.0 },
  { 1676.0000000000000, 2, 10, 
	  70.000000000000000, 0.0 },
  { 2306.0000000000000, 2, 10, 
	  80.000000000000000, 0.0 },
  { 3036.0000000000000, 2, 10, 
	  90.000000000000000, 0.0 },
  { 3866.0000000000000, 2, 10, 
	  100.00000000000000, 0.0 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for n=2, m=20.
// max(|f - f_GSL|): 5.6843418860808015e-13 at index 4
// max(|f - f_GSL| / |f_GSL|): 5.9211894646674663e-15
// mean(f - f_GSL): -6.0557619525008543e-14
// variance(f - f_GSL): 4.0339478107892650e-28
// stddev(f - f_GSL): 2.0084690216155350e-14
const testcase_assoc_laguerre<double>
data022[11] =
{
  { 231.00000000000000, 2, 20, 
	  0.0000000000000000, 0.0 },
  { 61.000000000000206, 2, 20, 
	  10.000000000000000, 0.0 },
  { -9.0000000000000053, 2, 20, 
	  20.000000000000000, 0.0 },
  { 21.000000000000124, 2, 20, 
	  30.000000000000000, 0.0 },
  { 151.00000000000057, 2, 20, 
	  40.000000000000000, 0.0 },
  { 381.00000000000000, 2, 20, 
	  50.000000000000000, 0.0 },
  { 711.00000000000000, 2, 20, 
	  60.000000000000000, 0.0 },
  { 1141.0000000000000, 2, 20, 
	  70.000000000000000, 0.0 },
  { 1670.9999999999998, 2, 20, 
	  80.000000000000000, 0.0 },
  { 2301.0000000000000, 2, 20, 
	  90.000000000000000, 0.0 },
  { 3031.0000000000000, 2, 20, 
	  100.00000000000000, 0.0 },
};
const double toler022 = 5.0000000000000039e-13;

// Test data for n=2, m=50.
// max(|f - f_GSL|): 3.6379788070917130e-12 at index 10
// max(|f - f_GSL| / |f_GSL|): 1.9243865760169750e-14
// mean(f - f_GSL): 1.1085274112784562e-12
// variance(f - f_GSL): 7.0379368001597960e-25
// stddev(f - f_GSL): 8.3892412053533160e-13
const testcase_assoc_laguerre<double>
data023[11] =
{
  { 1326.0000000000000, 2, 50, 
	  0.0000000000000000, 0.0 },
  { 855.99999999999693, 2, 50, 
	  10.000000000000000, 0.0 },
  { 485.99999999999835, 2, 50, 
	  20.000000000000000, 0.0 },
  { 215.99999999999937, 2, 50, 
	  30.000000000000000, 0.0 },
  { 45.999999999999829, 2, 50, 
	  40.000000000000000, 0.0 },
  { -23.999999999999538, 2, 50, 
	  50.000000000000000, 0.0 },
  { 6.0000000000001057, 2, 50, 
	  60.000000000000000, 0.0 },
  { 135.99999999999963, 2, 50, 
	  70.000000000000000, 0.0 },
  { 365.99999999999892, 2, 50, 
	  80.000000000000000, 0.0 },
  { 695.99999999999784, 2, 50, 
	  90.000000000000000, 0.0 },
  { 1125.9999999999964, 2, 50, 
	  100.00000000000000, 0.0 },
};
const double toler023 = 1.0000000000000008e-12;

// Test data for n=2, m=100.
// max(|f - f_GSL|): 6.5483618527650833e-11 at index 1
// max(|f - f_GSL| / |f_GSL|): 1.6416871873157281e-14
// mean(f - f_GSL): -2.0930328177696950e-11
// variance(f - f_GSL): 4.7796831888707054e-23
// stddev(f - f_GSL): 6.9135252866180405e-12
const testcase_assoc_laguerre<double>
data024[11] =
{
  { 5151.0000000000000, 2, 100, 
	  0.0000000000000000, 0.0 },
  { 4181.0000000000655, 2, 100, 
	  10.000000000000000, 0.0 },
  { 3311.0000000000518, 2, 100, 
	  20.000000000000000, 0.0 },
  { 2541.0000000000400, 2, 100, 
	  30.000000000000000, 0.0 },
  { 1871.0000000000291, 2, 100, 
	  40.000000000000000, 0.0 },
  { 1301.0000000000207, 2, 100, 
	  50.000000000000000, 0.0 },
  { 831.00000000001364, 2, 100, 
	  60.000000000000000, 0.0 },
  { 461.00000000000682, 2, 100, 
	  70.000000000000000, 0.0 },
  { 191.00000000000250, 2, 100, 
	  80.000000000000000, 0.0 },
  { 21.000000000000046, 2, 100, 
	  90.000000000000000, 0.0 },
  { -48.999999999999915, 2, 100, 
	  100.00000000000000, 0.0 },
};
const double toler024 = 1.0000000000000008e-12;

// Test data for n=5, m=0.
// max(|f - f_GSL|): 7.4505805969238281e-09 at index 10
// max(|f - f_GSL| / |f_GSL|): 1.9501553136894460e-16
// mean(f - f_GSL): -5.1328573714603078e-10
// variance(f - f_GSL): 5.2938665968649395e-18
// stddev(f - f_GSL): 2.3008404109944130e-09
const testcase_assoc_laguerre<double>
data025[11] =
{
  { 1.0000000000000000, 5, 0, 
	  0.0000000000000000, 0.0 },
  { 34.333333333333329, 5, 0, 
	  10.000000000000000, 0.0 },
  { -4765.6666666666670, 5, 0, 
	  20.000000000000000, 0.0 },
  { -74399.000000000000, 5, 0, 
	  30.000000000000000, 0.0 },
  { -418865.66666666663, 5, 0, 
	  40.000000000000000, 0.0 },
  { -1498165.6666666665, 5, 0, 
	  50.000000000000000, 0.0 },
  { -4122299.0000000000, 5, 0, 
	  60.000000000000000, 0.0 },
  { -9551265.6666666679, 5, 0, 
	  70.000000000000000, 0.0 },
  { -19595065.666666664, 5, 0, 
	  80.000000000000000, 0.0 },
  { -36713699.000000000, 5, 0, 
	  90.000000000000000, 0.0 },
  { -64117165.666666664, 5, 0, 
	  100.00000000000000, 0.0 },
};
const double toler025 = 2.5000000000000020e-13;

// Test data for n=5, m=1.
// max(|f - f_GSL|): 3.7252902984619141e-09 at index 8
// max(|f - f_GSL| / |f_GSL|): 3.1347473636475015e-16
// mean(f - f_GSL): -3.6516147681388907e-10
// variance(f - f_GSL): 1.4667719456379050e-20
// stddev(f - f_GSL): 1.2111036064837331e-10
const testcase_assoc_laguerre<double>
data026[11] =
{
  { 6.0000000000000000, 5, 1, 
	  0.0000000000000000, 0.0 },
  { 22.666666666666661, 5, 1, 
	  10.000000000000000, 0.0 },
  { -2960.6666666666661, 5, 1, 
	  20.000000000000000, 0.0 },
  { -58944.000000000000, 5, 1, 
	  30.000000000000000, 0.0 },
  { -357927.33333333326, 5, 1, 
	  40.000000000000000, 0.0 },
  { -1329910.6666666665, 5, 1, 
	  50.000000000000000, 0.0 },
  { -3744894.0000000000, 5, 1, 
	  60.000000000000000, 0.0 },
  { -8812877.3333333321, 5, 1, 
	  70.000000000000000, 0.0 },
  { -18283860.666666664, 5, 1, 
	  80.000000000000000, 0.0 },
  { -34547844.000000000, 5, 1, 
	  90.000000000000000, 0.0 },
  { -60734827.333333336, 5, 1, 
	  100.00000000000000, 0.0 },
};
const double toler026 = 2.5000000000000020e-13;

// Test data for n=5, m=2.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_laguerre<double>
data027[11] =
{
  { 21.000000000000000, 5, 2, 
	  0.0000000000000000, 0.0 },
  { 4.3333333333333339, 5, 2, 
	  10.000000000000000, 0.0 },
  { -1679.0000000000000, 5, 2, 
	  20.000000000000000, 0.0 },
  { -46029.000000000000, 5, 2, 
	  30.000000000000000, 0.0 },
  { -304045.66666666669, 5, 2, 
	  40.000000000000000, 0.0 },
  { -1176729.0000000002, 5, 2, 
	  50.000000000000000, 0.0 },
  { -3395079.0000000000, 5, 2, 
	  60.000000000000000, 0.0 },
  { -8120095.6666666660, 5, 2, 
	  70.000000000000000, 0.0 },
  { -17042778.999999996, 5, 2, 
	  80.000000000000000, 0.0 },
  { -32484129.000000000, 5, 2, 
	  90.000000000000000, 0.0 },
  { -57495145.666666664, 5, 2, 
	  100.00000000000000, 0.0 },
};
const double toler027 = 2.5000000000000020e-13;

// Test data for n=5, m=5.
// max(|f - f_GSL|): 7.4505805969238281e-09 at index 9
// max(|f - f_GSL| / |f_GSL|): 1.7763568394002536e-15
// mean(f - f_GSL): -1.0450849882462617e-09
// variance(f - f_GSL): 1.2014228959234583e-19
// stddev(f - f_GSL): 3.4661547800458338e-10
const testcase_assoc_laguerre<double>
data028[11] =
{
  { 252.00000000000000, 5, 5, 
	  0.0000000000000000, 0.0 },
  { -14.666666666666654, 5, 5, 
	  10.000000000000000, 0.0 },
  { 51.999999999999908, 5, 5, 
	  20.000000000000000, 0.0 },
  { -19548.000000000000, 5, 5, 
	  30.000000000000000, 0.0 },
  { -178814.66666666660, 5, 5, 
	  40.000000000000000, 0.0 },
  { -797747.99999999977, 5, 5, 
	  50.000000000000000, 0.0 },
  { -2496348.0000000000, 5, 5, 
	  60.000000000000000, 0.0 },
  { -6294614.6666666660, 5, 5, 
	  70.000000000000000, 0.0 },
  { -13712547.999999996, 5, 5, 
	  80.000000000000000, 0.0 },
  { -26870147.999999993, 5, 5, 
	  90.000000000000000, 0.0 },
  { -48587414.666666672, 5, 5, 
	  100.00000000000000, 0.0 },
};
const double toler028 = 2.5000000000000020e-13;

// Test data for n=5, m=10.
// max(|f - f_GSL|): 7.4505805969238281e-09 at index 10
// max(|f - f_GSL| / |f_GSL|): 1.9556222085140405e-15
// mean(f - f_GSL): -9.4849348577306296e-10
// variance(f - f_GSL): 4.6504850481092197e-18
// stddev(f - f_GSL): 2.1564983301892953e-09
const testcase_assoc_laguerre<double>
data029[11] =
{
  { 3003.0000000000000, 5, 10, 
	  0.0000000000000000, 0.0 },
  { 19.666666666666668, 5, 10, 
	  10.000000000000000, 0.0 },
  { 36.333333333333272, 5, 10, 
	  20.000000000000000, 0.0 },
  { -1947.0000000000000, 5, 10, 
	  30.000000000000000, 0.0 },
  { -60930.333333333314, 5, 10, 
	  40.000000000000000, 0.0 },
  { -381913.66666666651, 5, 10, 
	  50.000000000000000, 0.0 },
  { -1419897.0000000000, 5, 10, 
	  60.000000000000000, 0.0 },
  { -3979880.3333333330, 5, 10, 
	  70.000000000000000, 0.0 },
  { -9316863.6666666642, 5, 10, 
	  80.000000000000000, 0.0 },
  { -19235847.000000000, 5, 10, 
	  90.000000000000000, 0.0 },
  { -36191830.333333328, 5, 10, 
	  100.00000000000000, 0.0 },
};
const double toler029 = 2.5000000000000020e-13;

// Test data for n=5, m=20.
// max(|f - f_GSL|): 1.8626451492309570e-09 at index 8
// max(|f - f_GSL| / |f_GSL|): 2.8421709430404088e-15
// mean(f - f_GSL): 1.8654330605469030e-10
// variance(f - f_GSL): 3.8278245537195241e-21
// stddev(f - f_GSL): 6.1869415333584047e-11
const testcase_assoc_laguerre<double>
data030[11] =
{
  { 53130.000000000000, 5, 20, 
	  0.0000000000000000, 0.0 },
  { 1213.3333333333335, 5, 20, 
	  10.000000000000000, 0.0 },
  { 129.99999999999963, 5, 20, 
	  20.000000000000000, 0.0 },
  { -119.99999999999974, 5, 20, 
	  30.000000000000000, 0.0 },
  { 463.33333333333320, 5, 20, 
	  40.000000000000000, 0.0 },
  { -48120.000000000015, 5, 20, 
	  50.000000000000000, 0.0 },
  { -345870.00000000017, 5, 20, 
	  60.000000000000000, 0.0 },
  { -1342786.6666666667, 5, 20, 
	  70.000000000000000, 0.0 },
  { -3838870.0000000009, 5, 20, 
	  80.000000000000000, 0.0 },
  { -9084120.0000000000, 5, 20, 
	  90.000000000000000, 0.0 },
  { -18878536.666666668, 5, 20, 
	  100.00000000000000, 0.0 },
};
const double toler030 = 2.5000000000000020e-13;

// Test data for n=5, m=50.
// max(|f - f_GSL|): 5.8207660913467407e-11 at index 9
// max(|f - f_GSL| / |f_GSL|): 8.3212917817998576e-15
// mean(f - f_GSL): 2.5837917664003642e-12
// variance(f - f_GSL): 7.3435778813301465e-25
// stddev(f - f_GSL): 8.5694678255596164e-13
const testcase_assoc_laguerre<double>
data031[11] =
{
  { 3478761.0000000000, 5, 50, 
	  0.0000000000000000, 0.0 },
  { 1154544.3333333335, 5, 50, 
	  10.000000000000000, 0.0 },
  { 264661.00000000006, 5, 50, 
	  20.000000000000000, 0.0 },
  { 24111.000000000033, 5, 50, 
	  30.000000000000000, 0.0 },
  { -2105.6666666666665, 5, 50, 
	  40.000000000000000, 0.0 },
  { 1010.9999999999916, 5, 50, 
	  50.000000000000000, 0.0 },
  { -1538.9999999999955, 5, 50, 
	  60.000000000000000, 0.0 },
  { 5244.3333333333449, 5, 50, 
	  70.000000000000000, 0.0 },
  { -13639.000000000011, 5, 50, 
	  80.000000000000000, 0.0 },
  { -243189.00000000006, 5, 50, 
	  90.000000000000000, 0.0 },
  { -1118405.6666666667, 5, 50, 
	  100.00000000000000, 0.0 },
};
const double toler031 = 5.0000000000000039e-13;

// Test data for n=5, m=100.
// max(|f - f_GSL|): 1.4901161193847656e-08 at index 1
// max(|f - f_GSL| / |f_GSL|): 4.3934583843896481e-16
// mean(f - f_GSL): 9.3181866263462735e-10
// variance(f - f_GSL): 9.5511462203760402e-20
// stddev(f - f_GSL): 3.0904928766098203e-10
const testcase_assoc_laguerre<double>
data032[11] =
{
  { 96560646.000000000, 5, 100, 
	  0.0000000000000000, 0.0 },
  { 57264262.666666649, 5, 100, 
	  10.000000000000000, 0.0 },
  { 31841379.333333332, 5, 100, 
	  20.000000000000000, 0.0 },
  { 16281996.000000000, 5, 100, 
	  30.000000000000000, 0.0 },
  { 7426112.6666666670, 5, 100, 
	  40.000000000000000, 0.0 },
  { 2863729.3333333330, 5, 100, 
	  50.000000000000000, 0.0 },
  { 834846.00000000000, 5, 100, 
	  60.000000000000000, 0.0 },
  { 129462.66666666663, 5, 100, 
	  70.000000000000000, 0.0 },
  { -12420.666666666668, 5, 100, 
	  80.000000000000000, 0.0 },
  { -804.00000000000000, 5, 100, 
	  90.000000000000000, 0.0 },
  { 4312.6666666666670, 5, 100, 
	  100.00000000000000, 0.0 },
};
const double toler032 = 2.5000000000000020e-13;

// Test data for n=10, m=0.
// max(|f - f_GSL|): 6.1035156250000000e-05 at index 7
// max(|f - f_GSL| / |f_GSL|): 6.1315986390500118e-15
// mean(f - f_GSL): -5.5892985322068194e-06
// variance(f - f_GSL): 3.4364283890538241e-12
// stddev(f - f_GSL): 1.8537606072667053e-06
const testcase_assoc_laguerre<double>
data033[11] =
{
  { 1.0000000000000000, 10, 0, 
	  0.0000000000000000, 0.0 },
  { 27.984126984126977, 10, 0, 
	  10.000000000000000, 0.0 },
  { 3227.8077601410932, 10, 0, 
	  20.000000000000000, 0.0 },
  { 15129.571428571455, 10, 0, 
	  30.000000000000000, 0.0 },
  { 79724066.608465582, 10, 0, 
	  40.000000000000000, 0.0 },
  { 2037190065.3738980, 10, 0, 
	  50.000000000000000, 0.0 },
  { 21804200401.000000, 10, 0, 
	  60.000000000000000, 0.0 },
  { 144688291819.51855, 10, 0, 
	  70.000000000000000, 0.0 },
  { 703324772760.08276, 10, 0, 
	  80.000000000000000, 0.0 },
  { 2741055412243.8569, 10, 0, 
	  90.000000000000000, 0.0 },
  { 9051283795429.5723, 10, 0, 
	  100.00000000000000, 0.0 },
};
const double toler033 = 5.0000000000000039e-13;

// Test data for n=10, m=1.
// max(|f - f_GSL|): 0.0019531250000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 3.2082933888884751e-16
// mean(f - f_GSL): -0.00017647174536266681
// variance(f - f_GSL): 3.4721464659347714e-07
// stddev(f - f_GSL): 0.00058924922281957846
const testcase_assoc_laguerre<double>
data034[11] =
{
  { 11.000000000000000, 10, 1, 
	  0.0000000000000000, 0.0 },
  { 14.791887125220455, 10, 1, 
	  10.000000000000000, 0.0 },
  { 2704.6507936507933, 10, 1, 
	  20.000000000000000, 0.0 },
  { -182924.71428571423, 10, 1, 
	  30.000000000000000, 0.0 },
  { 48066036.749559075, 10, 1, 
	  40.000000000000000, 0.0 },
  { 1486264192.2169311, 10, 1, 
	  50.000000000000000, 0.0 },
  { 17239562282.428574, 10, 1, 
	  60.000000000000000, 0.0 },
  { 119837491630.13579, 10, 1, 
	  70.000000000000000, 0.0 },
  { 600681375251.21167, 10, 1, 
	  80.000000000000000, 0.0 },
  { 2392908405632.4287, 10, 1, 
	  90.000000000000000, 0.0 },
  { 8033035722509.2373, 10, 1, 
	  100.00000000000000, 0.0 },
};
const double toler034 = 2.5000000000000020e-13;

// Test data for n=10, m=2.
// max(|f - f_GSL|): 0.00012207031250000000 at index 8
// max(|f - f_GSL| / |f_GSL|): 3.0884259455918855e-16
// mean(f - f_GSL): 1.4045021730039894e-05
// variance(f - f_GSL): 2.1698889894483716e-11
// stddev(f - f_GSL): 4.6582067251769446e-06
const testcase_assoc_laguerre<double>
data035[11] =
{
  { 66.000000000000000, 10, 2, 
	  0.0000000000000000, 0.0 },
  { -14.511463844797181, 10, 2, 
	  10.000000000000000, 0.0 },
  { 1064.5890652557316, 10, 2, 
	  20.000000000000000, 0.0 },
  { -194569.71428571429, 10, 2, 
	  30.000000000000000, 0.0 },
  { 27343569.350970022, 10, 2, 
	  40.000000000000000, 0.0 },
  { 1067807661.6790125, 10, 2, 
	  50.000000000000000, 0.0 },
  { 13529451580.285711, 10, 2, 
	  60.000000000000000, 0.0 },
  { 98812724224.641937, 10, 2, 
	  70.000000000000000, 0.0 },
  { 511482736187.34021, 10, 2, 
	  80.000000000000000, 0.0 },
  { 2084478393087.4285, 10, 2, 
	  90.000000000000000, 0.0 },
  { 7117724862237.0752, 10, 2, 
	  100.00000000000000, 0.0 },
};
const double toler035 = 2.5000000000000020e-13;

// Test data for n=10, m=5.
// max(|f - f_GSL|): 0.0019531250000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 5.4929549774030811e-15
// mean(f - f_GSL): 0.00020540323628249655
// variance(f - f_GSL): 3.3599844999940669e-07
// stddev(f - f_GSL): 0.00057965373284350253
const testcase_assoc_laguerre<double>
data036[11] =
{
  { 3003.0000000000000, 10, 5, 
	  0.0000000000000000, 0.0 },
  { 11.641975308642031, 10, 5, 
	  10.000000000000000, 0.0 },
  { -1137.5643738977069, 10, 5, 
	  20.000000000000000, 0.0 },
  { -9254.1428571428605, 10, 5, 
	  30.000000000000000, 0.0 },
  { 2121878.8377425023, 10, 5, 
	  40.000000000000000, 0.0 },
  { 352060171.43033499, 10, 5, 
	  50.000000000000000, 0.0 },
  { 6212028560.1428576, 10, 5, 
	  60.000000000000000, 0.0 },
  { 53782171674.604919, 10, 5, 
	  70.000000000000000, 0.0 },
  { 309720255837.56775, 10, 5, 
	  80.000000000000000, 0.0 },
  { 1359043035731.5713, 10, 5, 
	  90.000000000000000, 0.0 },
  { 4900625954398.9434, 10, 5, 
	  100.00000000000000, 0.0 },
};
const double toler036 = 5.0000000000000039e-13;

// Test data for n=10, m=10.
// max(|f - f_GSL|): 0.00048828125000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 1.2999856205575476e-15
// mean(f - f_GSL): 3.5049890987631279e-05
// variance(f - f_GSL): 2.2596053129284716e-08
// stddev(f - f_GSL): 0.00015031983611381671
const testcase_assoc_laguerre<double>
data037[11] =
{
  { 184756.00000000000, 10, 10, 
	  0.0000000000000000, 0.0 },
  { -210.84303350970018, 10, 10, 
	  10.000000000000000, 0.0 },
  { 508.38095238095184, 10, 10, 
	  20.000000000000000, 0.0 },
  { 2098.8571428571431, 10, 10, 
	  30.000000000000000, 0.0 },
  { -536338.88536155177, 10, 10, 
	  40.000000000000000, 0.0 },
  { 24865988.804232784, 10, 10, 
	  50.000000000000000, 0.0 },
  { 1343756013.1428571, 10, 10, 
	  60.000000000000000, 0.0 },
  { 17298791247.358025, 10, 10, 
	  70.000000000000000, 0.0 },
  { 124528450897.79892, 10, 10, 
	  80.000000000000000, 0.0 },
  { 632674413641.71423, 10, 10, 
	  90.000000000000000, 0.0 },
  { 2533008935405.0298, 10, 10, 
	  100.00000000000000, 0.0 },
};
const double toler037 = 2.5000000000000020e-13;

// Test data for n=10, m=20.
// max(|f - f_GSL|): 1.1444091796875000e-05 at index 8
// max(|f - f_GSL| / |f_GSL|): 1.3165826881543491e-14
// mean(f - f_GSL): -1.0290407937480433e-06
// variance(f - f_GSL): 1.1648174507175886e-13
// stddev(f - f_GSL): 3.4129422068320885e-07
const testcase_assoc_laguerre<double>
data038[11] =
{
  { 30045014.999999993, 10, 20, 
	  0.0000000000000000, 0.0 },
  { -23087.733686067022, 10, 20, 
	  10.000000000000000, 0.0 },
  { 207.23985890652330, 10, 20, 
	  20.000000000000000, 0.0 },
  { 1407.8571428571508, 10, 20, 
	  30.000000000000000, 0.0 },
  { -44618.156966490322, 10, 20, 
	  40.000000000000000, 0.0 },
  { 158690.04409171100, 10, 20, 
	  50.000000000000000, 0.0 },
  { -6870413.5714285728, 10, 20, 
	  60.000000000000000, 0.0 },
  { 793841351.41975331, 10, 20, 
	  70.000000000000000, 0.0 },
  { 13358288958.562618, 10, 20, 
	  80.000000000000000, 0.0 },
  { 106073722407.85715, 10, 20, 
	  90.000000000000000, 0.0 },
  { 566337213392.42493, 10, 20, 
	  100.00000000000000, 0.0 },
};
const double toler038 = 1.0000000000000008e-12;

// Test data for n=10, m=50.
// max(|f - f_GSL|): 1.7881393432617188e-07 at index 2
// max(|f - f_GSL| / |f_GSL|): 1.9220038158581863e-14
// mean(f - f_GSL): -1.7959874557246538e-08
// variance(f - f_GSL): 1.5426792767859101e-17
// stddev(f - f_GSL): 3.9276956052956932e-09
const testcase_assoc_laguerre<double>
data039[11] =
{
  { 75394027566.000000, 10, 50, 
	  0.0000000000000000, 0.0 },
  { 8048106183.3721361, 10, 50, 
	  10.000000000000000, 0.0 },
  { 328045023.84832460, 10, 50, 
	  20.000000000000000, 0.0 },
  { -2568769.7142857178, 10, 50, 
	  30.000000000000000, 0.0 },
  { 6971.9964726631533, 10, 50, 
	  40.000000000000000, 0.0 },
  { 136111.41446207993, 10, 50, 
	  50.000000000000000, 0.0 },
  { -62462.571428570242, 10, 50, 
	  60.000000000000000, 0.0 },
  { -248167.95061728527, 10, 50, 
	  70.000000000000000, 0.0 },
  { 1941270.4091710770, 10, 50, 
	  80.000000000000000, 0.0 },
  { -8643512.5714285765, 10, 50, 
	  90.000000000000000, 0.0 },
  { -140863522.18342152, 10, 50, 
	  100.00000000000000, 0.0 },
};
const double toler039 = 1.0000000000000008e-12;

// Test data for n=10, m=100.
// max(|f - f_GSL|): 0.0019531250000000000 at index 1
// max(|f - f_GSL| / |f_GSL|): 8.5796208358610616e-15
// mean(f - f_GSL): 0.00016085392880168828
// variance(f - f_GSL): 2.8461549974308565e-09
// stddev(f - f_GSL): 5.3349367357362886e-05
const testcase_assoc_laguerre<double>
data040[11] =
{
  { 46897636623981.000, 10, 100, 
	  0.0000000000000000, 0.0 },
  { 16444031323272.084, 10, 100, 
	  10.000000000000000, 0.0 },
  { 5020343986463.5391, 10, 100, 
	  20.000000000000000, 0.0 },
  { 1270977490645.2859, 10, 100, 
	  30.000000000000000, 0.0 },
  { 244835756822.62262, 10, 100, 
	  40.000000000000000, 0.0 },
  { 29786827693.962959, 10, 100, 
	  50.000000000000000, 0.0 },
  { 1127612095.2857144, 10, 100, 
	  60.000000000000000, 0.0 },
  { -66370555.419753075, 10, 100, 
	  70.000000000000000, 0.0 },
  { 10420852.957671870, 10, 100, 
	  80.000000000000000, 0.0 },
  { -3373097.5714285718, 10, 100, 
	  90.000000000000000, 0.0 },
  { 2065423.6807760145, 10, 100, 
	  100.00000000000000, 0.0 },
};
const double toler040 = 5.0000000000000039e-13;

// Test data for n=20, m=0.
// max(|f - f_GSL|): 20.000000000000000 at index 8
// max(|f - f_GSL| / |f_GSL|): 4.7350442720305269e-15
// mean(f - f_GSL): -1.8323417989965736
// variance(f - f_GSL): 2754690.9677631622
// stddev(f - f_GSL): 1659.7261725246012
const testcase_assoc_laguerre<double>
data041[11] =
{
  { 1.0000000000000000, 20, 0, 
	  0.0000000000000000, 0.0 },
  { -11.961333867812119, 20, 0, 
	  10.000000000000000, 0.0 },
  { 2829.4728613531743, 20, 0, 
	  20.000000000000000, 0.0 },
  { -18439.424502520938, 20, 0, 
	  30.000000000000000, 0.0 },
  { 24799805.877530713, 20, 0, 
	  40.000000000000000, 0.0 },
  { 7551960453.7672548, 20, 0, 
	  50.000000000000000, 0.0 },
  { -1379223608444.9155, 20, 0, 
	  60.000000000000000, 0.0 },
  { 165423821874449.94, 20, 0, 
	  70.000000000000000, 0.0 },
  { 29500368536981676., 20, 0, 
	  80.000000000000000, 0.0 },
  { 1.1292309514432901e+18, 20, 0, 
	  90.000000000000000, 0.0 },
  { 2.2061882785931735e+19, 20, 0, 
	  100.00000000000000, 0.0 },
};
const double toler041 = 2.5000000000000020e-13;

// Test data for n=20, m=1.
// max(|f - f_GSL|): 8192.0000000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 2.0583579235866667e-15
// mean(f - f_GSL): -744.54973777790485
// variance(f - f_GSL): 6101096.7248424273
// stddev(f - f_GSL): 2470.0398225215777
const testcase_assoc_laguerre<double>
data042[11] =
{
  { 21.000000000000000, 20, 1, 
	  0.0000000000000000, 0.0 },
  { 19.900488129734079, 20, 1, 
	  10.000000000000000, 0.0 },
  { 2208.0318569557585, 20, 1, 
	  20.000000000000000, 0.0 },
  { 263690.96303121914, 20, 1, 
	  30.000000000000000, 0.0 },
  { 40667285.630564235, 20, 1, 
	  40.000000000000000, 0.0 },
  { 1737442572.8115399, 20, 1, 
	  50.000000000000000, 0.0 },
  { -588280953643.28125, 20, 1, 
	  60.000000000000000, 0.0 },
  { 45617733778241.328, 20, 1, 
	  70.000000000000000, 0.0 },
  { 17293487114876864., 20, 1, 
	  80.000000000000000, 0.0 },
  { 7.6219135858585062e+17, 20, 1, 
	  90.000000000000000, 0.0 },
  { 1.6037288204336759e+19, 20, 1, 
	  100.00000000000000, 0.0 },
};
const double toler042 = 2.5000000000000020e-13;

// Test data for n=20, m=2.
// max(|f - f_GSL|): 6144.0000000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 9.3068805041852228e-15
// mean(f - f_GSL): 610.73011506755233
// variance(f - f_GSL): 995562063.33027601
// stddev(f - f_GSL): 31552.528636074101
const testcase_assoc_laguerre<double>
data043[11] =
{
  { 231.00000000000003, 20, 2, 
	  0.0000000000000000, 0.0 },
  { 47.009338065112921, 20, 2, 
	  10.000000000000000, 0.0 },
  { -652.51305461728589, 20, 2, 
	  20.000000000000000, 0.0 },
  { 285388.25895069109, 20, 2, 
	  30.000000000000000, 0.0 },
  { 28664069.685624730, 20, 2, 
	  40.000000000000000, 0.0 },
  { -1399631966.3144732, 20, 2, 
	  50.000000000000000, 0.0 },
  { -115357373248.28194, 20, 2, 
	  60.000000000000000, 0.0 },
  { -3357730872975.8750, 20, 2, 
	  70.000000000000000, 0.0 },
  { 9765808962855122.0, 20, 2, 
	  80.000000000000000, 0.0 },
  { 5.0717292945559181e+17, 20, 2, 
	  90.000000000000000, 0.0 },
  { 1.1564665701334456e+19, 20, 2, 
	  100.00000000000000, 0.0 },
};
const double toler043 = 5.0000000000000039e-13;

// Test data for n=20, m=5.
// max(|f - f_GSL|): 16.000000000000000 at index 9
// max(|f - f_GSL| / |f_GSL|): 3.5731302592472765e-15
// mean(f - f_GSL): -1.4092810048974798
// variance(f - f_GSL): 598.27450725320409
// stddev(f - f_GSL): 24.459650595484884
const testcase_assoc_laguerre<double>
data044[11] =
{
  { 53130.000000000000, 20, 5, 
	  0.0000000000000000, 0.0 },
  { -158.69554500944142, 20, 5, 
	  10.000000000000000, 0.0 },
  { 334.08012288038952, 20, 5, 
	  20.000000000000000, 0.0 },
  { -198372.47662554163, 20, 5, 
	  30.000000000000000, 0.0 },
  { -13627144.088579426, 20, 5, 
	  40.000000000000000, 0.0 },
  { -780579985.44731510, 20, 5, 
	  50.000000000000000, 0.0 },
  { 116648634237.73535, 20, 5, 
	  60.000000000000000, 0.0 },
  { -12347348707739.742, 20, 5, 
	  70.000000000000000, 0.0 },
  { 1199516248034090.8, 20, 5, 
	  80.000000000000000, 0.0 },
  { 1.3451503195078531e+17, 20, 5, 
	  90.000000000000000, 0.0 },
  { 4.1058904276111483e+18, 20, 5, 
	  100.00000000000000, 0.0 },
};
const double toler044 = 2.5000000000000020e-13;

// Test data for n=20, m=10.
// max(|f - f_GSL|): 64.000000000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 1.0709209504860220e-15
// mean(f - f_GSL): -5.5440786440316181
// variance(f - f_GSL): 376.60778837733284
// stddev(f - f_GSL): 19.406385247575933
const testcase_assoc_laguerre<double>
data045[11] =
{
  { 30045015.000000000, 20, 10, 
	  0.0000000000000000, 0.0 },
  { -1755.6226861258601, 20, 10, 
	  10.000000000000000, 0.0 },
  { -9081.6726644737901, 20, 10, 
	  20.000000000000000, 0.0 },
  { 95771.650912113109, 20, 10, 
	  30.000000000000000, 0.0 },
  { 5089151.9272779236, 20, 10, 
	  40.000000000000000, 0.0 },
  { 97400399.450206712, 20, 10, 
	  50.000000000000000, 0.0 },
  { -16009352450.477026, 20, 10, 
	  60.000000000000000, 0.0 },
  { 842271286905.01050, 20, 10, 
	  70.000000000000000, 0.0 },
  { -79901725466796.938, 20, 10, 
	  80.000000000000000, 0.0 },
  { 7944103675858637.0, 20, 10, 
	  90.000000000000000, 0.0 },
  { 5.7429821893388288e+17, 20, 10, 
	  100.00000000000000, 0.0 },
};
const double toler045 = 2.5000000000000020e-13;

// Test data for n=20, m=20.
// max(|f - f_GSL|): 2.1250000000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 1.1968937782285294e-14
// mean(f - f_GSL): 0.19344895682429938
// variance(f - f_GSL): 0.41039783756558101
// stddev(f - f_GSL): 0.64062300736515931
const testcase_assoc_laguerre<double>
data046[11] =
{
  { 137846528819.99994, 20, 20, 
	  0.0000000000000000, 0.0 },
  { -136976.49571333229, 20, 20, 
	  10.000000000000000, 0.0 },
  { 113878.49908041643, 20, 20, 
	  20.000000000000000, 0.0 },
  { -342529.21778796182, 20, 20, 
	  30.000000000000000, 0.0 },
  { -350112.66981443466, 20, 20, 
	  40.000000000000000, 0.0 },
  { -10791735.172977809, 20, 20, 
	  50.000000000000000, 0.0 },
  { -1038073940.0811402, 20, 20, 
	  60.000000000000000, 0.0 },
  { 667312550.63616335, 20, 20, 
	  70.000000000000000, 0.0 },
  { 741537869902.29028, 20, 20, 
	  80.000000000000000, 0.0 },
  { -32378376755737.418, 20, 20, 
	  90.000000000000000, 0.0 },
  { -601760332167937.62, 20, 20, 
	  100.00000000000000, 0.0 },
};
const double toler046 = 1.0000000000000008e-12;

// Test data for n=20, m=50.
// max(|f - f_GSL|): 0.25000000000000000 at index 1
// max(|f - f_GSL| / |f_GSL|): 1.2103144092558234e-14
// mean(f - f_GSL): -0.022849527272311123
// variance(f - f_GSL): 5.7130155161570465e-05
// stddev(f - f_GSL): 0.0075584492563997852
const testcase_assoc_laguerre<double>
data047[11] =
{
  { 1.6188460366265789e+17, 20, 50, 
	  0.0000000000000000, 0.0 },
  { 1599011936804291.5, 20, 50, 
	  10.000000000000000, 0.0 },
  { -131273880831.42432, 20, 50, 
	  20.000000000000000, 0.0 },
  { -3133213093.6903548, 20, 50, 
	  30.000000000000000, 0.0 },
  { -213935628.04985175, 20, 50, 
	  40.000000000000000, 0.0 },
  { -47375578.495921060, 20, 50, 
	  50.000000000000000, 0.0 },
  { -115731015.14034876, 20, 50, 
	  60.000000000000000, 0.0 },
  { -737415147.29420292, 20, 50, 
	  70.000000000000000, 0.0 },
  { -2123455626.8621769, 20, 50, 
	  80.000000000000000, 0.0 },
  { 29801266858.608929, 20, 50, 
	  90.000000000000000, 0.0 },
  { -132886631026.82553, 20, 50, 
	  100.00000000000000, 0.0 },
};
const double toler047 = 1.0000000000000008e-12;

// Test data for n=20, m=100.
// max(|f - f_GSL|): 1572864.0000000000 at index 1
// max(|f - f_GSL| / |f_GSL|): 3.6621229371267356e-14
// mean(f - f_GSL): 137262.28072981400
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_laguerre<double>
data048[11] =
{
  { 2.9462227291176643e+22, 20, 100, 
	  0.0000000000000000, 0.0 },
  { 3.5777890748701244e+21, 20, 100, 
	  10.000000000000000, 0.0 },
  { 3.1584925521456759e+20, 20, 100, 
	  20.000000000000000, 0.0 },
  { 1.7389599388424864e+19, 20, 100, 
	  30.000000000000000, 0.0 },
  { 4.1401342745980634e+17, 20, 100, 
	  40.000000000000000, 0.0 },
  { -79359706102062.594, 20, 100, 
	  50.000000000000000, 0.0 },
  { 22736203650743.145, 20, 100, 
	  60.000000000000000, 0.0 },
  { 65679006380.095703, 20, 100, 
	  70.000000000000000, 0.0 },
  { -236263257610.77792, 20, 100, 
	  80.000000000000000, 0.0 },
  { -38072644585.303101, 20, 100, 
	  90.000000000000000, 0.0 },
  { 68236474365.173973, 20, 100, 
	  100.00000000000000, 0.0 },
};
const double toler048 = 2.5000000000000015e-12;

// Test data for n=50, m=0.
// max(|f - f_GSL|): 196608.00000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 4.2910775919271532e-15
// mean(f - f_GSL): -17990.447398879332
// variance(f - f_GSL): 27618453284.204639
// stddev(f - f_GSL): 166188.00583737876
const testcase_assoc_laguerre<double>
data049[11] =
{
  { 1.0000000000000000, 50, 0, 
	  0.0000000000000000, 0.0 },
  { 17.534183446338233, 50, 0, 
	  10.000000000000000, 0.0 },
  { 980.26961889791028, 50, 0, 
	  20.000000000000000, 0.0 },
  { 293000.50735962362, 50, 0, 
	  30.000000000000000, 0.0 },
  { -14896937.968694873, 50, 0, 
	  40.000000000000000, 0.0 },
  { 2513677852.6916871, 50, 0, 
	  50.000000000000000, 0.0 },
  { -883876565337.99219, 50, 0, 
	  60.000000000000000, 0.0 },
  { -80967880733583.234, 50, 0, 
	  70.000000000000000, 0.0 },
  { -8217471769564841.0, 50, 0, 
	  80.000000000000000, 0.0 },
  { -2.1140031308048891e+18, 50, 0, 
	  90.000000000000000, 0.0 },
  { -3.9710103487094692e+20, 50, 0, 
	  100.00000000000000, 0.0 },
};
const double toler049 = 2.5000000000000020e-13;

// Test data for n=50, m=1.
// max(|f - f_GSL|): 311296.00000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 4.3113718426975911e-14
// mean(f - f_GSL): 28417.096591423862
// variance(f - f_GSL): 32927254885.825413
// stddev(f - f_GSL): 181458.68644356879
const testcase_assoc_laguerre<double>
data050[11] =
{
  { 51.000000000000021, 50, 1, 
	  0.0000000000000000, 0.0 },
  { 1.4214573271639575, 50, 1, 
	  10.000000000000000, 0.0 },
  { -2574.8072295127827, 50, 1, 
	  20.000000000000000, 0.0 },
  { 35846.479728359205, 50, 1, 
	  30.000000000000000, 0.0 },
  { -48263698.768318526, 50, 1, 
	  40.000000000000000, 0.0 },
  { 6161525870.2738533, 50, 1, 
	  50.000000000000000, 0.0 },
  { -382655486658.47125, 50, 1, 
	  60.000000000000000, 0.0 },
  { -109635579833241.72, 50, 1, 
	  70.000000000000000, 0.0 },
  { -14623805817283490., 50, 1, 
	  80.000000000000000, 0.0 },
  { -2.0666847190878152e+18, 50, 1, 
	  90.000000000000000, 0.0 },
  { -1.4385187953997626e+20, 50, 1, 
	  100.00000000000000, 0.0 },
};
const double toler050 = 2.5000000000000015e-12;

// Test data for n=50, m=2.
// max(|f - f_GSL|): 139264.00000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 2.5437687254653283e-15
// mean(f - f_GSL): 12649.078840684118
// variance(f - f_GSL): 1765904219.6855280
// stddev(f - f_GSL): 42022.663167456769
const testcase_assoc_laguerre<double>
data051[11] =
{
  { 1326.0000000000000, 50, 2, 
	  0.0000000000000000, 0.0 },
  { -87.860732516444529, 50, 2, 
	  10.000000000000000, 0.0 },
  { -5203.2351191780917, 50, 2, 
	  20.000000000000000, 0.0 },
  { -461059.50012538867, 50, 2, 
	  30.000000000000000, 0.0 },
  { -30476695.327440590, 50, 2, 
	  40.000000000000000, 0.0 },
  { 3720804977.9338136, 50, 2, 
	  50.000000000000000, 0.0 },
  { 362262002434.51453, 50, 2, 
	  60.000000000000000, 0.0 },
  { -52210917867820.227, 50, 2, 
	  70.000000000000000, 0.0 },
  { -9567965136901914.0, 50, 2, 
	  80.000000000000000, 0.0 },
  { -8.9171277517712883e+17, 50, 2, 
	  90.000000000000000, 0.0 },
  { 5.7231129448806982e+19, 50, 2, 
	  100.00000000000000, 0.0 },
};
const double toler051 = 2.5000000000000020e-13;

// Test data for n=50, m=5.
// max(|f - f_GSL|): 81920.000000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 2.6215979818234617e-15
// mean(f - f_GSL): -7423.7222822287622
// variance(f - f_GSL): 648926959.11275744
// stddev(f - f_GSL): 25474.044812568685
const testcase_assoc_laguerre<double>
data052[11] =
{
  { 3478761.0000000000, 50, 5, 
	  0.0000000000000000, 0.0 },
  { 1055.8381917651498, 50, 5, 
	  10.000000000000000, 0.0 },
  { 15264.646660345055, 50, 5, 
	  20.000000000000000, 0.0 },
  { 1229651.8966600848, 50, 5, 
	  30.000000000000000, 0.0 },
  { 39270451.823656842, 50, 5, 
	  40.000000000000000, 0.0 },
  { -4424062601.1152029, 50, 5, 
	  50.000000000000000, 0.0 },
  { -186017434284.19223, 50, 5, 
	  60.000000000000000, 0.0 },
  { 50972853949302.609, 50, 5, 
	  70.000000000000000, 0.0 },
  { 6530702754012517.0, 50, 5, 
	  80.000000000000000, 0.0 },
  { 6.8387592714678029e+17, 50, 5, 
	  90.000000000000000, 0.0 },
  { 3.9198742504338391e+19, 50, 5, 
	  100.00000000000000, 0.0 },
};
const double toler052 = 2.5000000000000020e-13;

// Test data for n=50, m=10.
// max(|f - f_GSL|): 192.00000000000000 at index 9
// max(|f - f_GSL| / |f_GSL|): 3.6229303412867937e-15
// mean(f - f_GSL): -17.490024036237049
// variance(f - f_GSL): 12219580.275082903
// stddev(f - f_GSL): 3495.6516238153513
const testcase_assoc_laguerre<double>
data053[11] =
{
  { 75394027565.999985, 50, 10, 
	  0.0000000000000000, 0.0 },
  { 91833.924098770178, 50, 10, 
	  10.000000000000000, 0.0 },
  { 330501.87929778261, 50, 10, 
	  20.000000000000000, 0.0 },
  { 3625088.1635972536, 50, 10, 
	  30.000000000000000, 0.0 },
  { 213954727.28632012, 50, 10, 
	  40.000000000000000, 0.0 },
  { -9381006937.7517681, 50, 10, 
	  50.000000000000000, 0.0 },
  { 535333683777.48615, 50, 10, 
	  60.000000000000000, 0.0 },
  { 18824406573722.172, 50, 10, 
	  70.000000000000000, 0.0 },
  { -533858276780013.12, 50, 10, 
	  80.000000000000000, 0.0 },
  { -52995774666704016., 50, 10, 
	  90.000000000000000, 0.0 },
  { 6.0504182862448783e+18, 50, 10, 
	  100.00000000000000, 0.0 },
};
const double toler053 = 2.5000000000000020e-13;

// Test data for n=50, m=20.
// max(|f - f_GSL|): 512.00000000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 9.6616871455409171e-14
// mean(f - f_GSL): -47.364405233074315
// variance(f - f_GSL): 23782.450110032125
// stddev(f - f_GSL): 154.21559619581973
const testcase_assoc_laguerre<double>
data054[11] =
{
  { 1.6188460366265779e+17, 50, 20, 
	  0.0000000000000000, 0.0 },
  { -307637087.25169408, 50, 20, 
	  10.000000000000000, 0.0 },
  { 12524651.102974586, 50, 20, 
	  20.000000000000000, 0.0 },
  { -315460483.86210561, 50, 20, 
	  30.000000000000000, 0.0 },
  { -1889683587.3459988, 50, 20, 
	  40.000000000000000, 0.0 },
  { 37457044404.200348, 50, 20, 
	  50.000000000000000, 0.0 },
  { -843831858224.71802, 50, 20, 
	  60.000000000000000, 0.0 },
  { -92231643172.307495, 50, 20, 
	  70.000000000000000, 0.0 },
  { 904211757769501.00, 50, 20, 
	  80.000000000000000, 0.0 },
  { 46508193600283272., 50, 20, 
	  90.000000000000000, 0.0 },
  { 2.3216887928162719e+18, 50, 20, 
	  100.00000000000000, 0.0 },
};
const double toler054 = 5.0000000000000029e-12;

// Test data for n=50, m=50.
// max(|f - f_GSL|): 989855744.00000000 at index 1
// max(|f - f_GSL| / |f_GSL|): 1.1139535389485780e-14
// mean(f - f_GSL): 89986812.018465906
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_laguerre<double>
data055[11] =
{
  { 1.0089134454556417e+29, 50, 50, 
	  0.0000000000000000, 0.0 },
  { 1.3822795753070493e+23, 50, 50, 
	  10.000000000000000, 0.0 },
  { 95817260381628336., 50, 50, 
	  20.000000000000000, 0.0 },
  { -910798580856015.38, 50, 50, 
	  30.000000000000000, 0.0 },
  { 50513254049166.922, 50, 50, 
	  40.000000000000000, 0.0 },
  { 84159703903348.938, 50, 50, 
	  50.000000000000000, 0.0 },
  { -138805244691822.72, 50, 50, 
	  60.000000000000000, 0.0 },
  { 181046391269246.25, 50, 50, 
	  70.000000000000000, 0.0 },
  { 2086884905317107.5, 50, 50, 
	  80.000000000000000, 0.0 },
  { -2765620139862428.0, 50, 50, 
	  90.000000000000000, 0.0 },
  { -1.3706751678146290e+17, 50, 50, 
	  100.00000000000000, 0.0 },
};
const double toler055 = 1.0000000000000008e-12;

// Test data for n=50, m=100.
// max(|f - f_GSL|): 1.8889465931478581e+22 at index 1
// max(|f - f_GSL| / |f_GSL|): 2.2737143709403468e-14
// mean(f - f_GSL): -1.7004551248566624e+21
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_laguerre<double>
data056[11] =
{
  { 2.0128660909731929e+40, 50, 100, 
	  0.0000000000000000, 0.0 },
  { 9.3675094807695474e+37, 50, 100, 
	  10.000000000000000, 0.0 },
  { 1.3009321481877196e+35, 50, 100, 
	  20.000000000000000, 0.0 },
  { 7.3720026893233823e+30, 50, 100, 
	  30.000000000000000, 0.0 },
  { -6.0824679079634667e+25, 50, 100, 
	  40.000000000000000, 0.0 },
  { -6.0053188793543450e+23, 50, 100, 
	  50.000000000000000, 0.0 },
  { 1.4178129287264692e+22, 50, 100, 
	  60.000000000000000, 0.0 },
  { -5.4652099341566706e+20, 50, 100, 
	  70.000000000000000, 0.0 },
  { -1.0817271759263274e+20, 50, 100, 
	  80.000000000000000, 0.0 },
  { 3.8058734007924195e+19, 50, 100, 
	  90.000000000000000, 0.0 },
  { 4.7439240848028344e+19, 50, 100, 
	  100.00000000000000, 0.0 },
};
const double toler056 = 2.5000000000000015e-12;

// Test data for n=100, m=0.
// max(|f - f_GSL|): 98304.000000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 3.8776197831393928e-15
// mean(f - f_GSL): -8865.4606155926431
// variance(f - f_GSL): 4058808072.1721206
// stddev(f - f_GSL): 63708.775472238682
const testcase_assoc_laguerre<double>
data057[11] =
{
  { 1.0000000000000000, 100, 0, 
	  0.0000000000000000, 0.0 },
  { 13.277662844303450, 100, 0, 
	  10.000000000000000, 0.0 },
  { 1854.0367283243388, 100, 0, 
	  20.000000000000000, 0.0 },
  { 170141.86987046551, 100, 0, 
	  30.000000000000000, 0.0 },
  { -7272442.3156006960, 100, 0, 
	  40.000000000000000, 0.0 },
  { 4847420871.2690506, 100, 0, 
	  50.000000000000000, 0.0 },
  { 693492765740.29688, 100, 0, 
	  60.000000000000000, 0.0 },
  { 17125518672239.770, 100, 0, 
	  70.000000000000000, 0.0 },
  { -13763178176383768., 100, 0, 
	  80.000000000000000, 0.0 },
  { 2.1307220490380173e+18, 100, 0, 
	  90.000000000000000, 0.0 },
  { -2.6292260693068916e+20, 100, 0, 
	  100.00000000000000, 0.0 },
};
const double toler057 = 2.5000000000000020e-13;

// Test data for n=100, m=1.
// max(|f - f_GSL|): 245760.00000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 1.4500034612453474e-14
// mean(f - f_GSL): 22224.249977270934
// variance(f - f_GSL): 29644360933.494530
// stddev(f - f_GSL): 172175.37841832824
const testcase_assoc_laguerre<double>
data058[11] =
{
  { 101.00000000000003, 100, 1, 
	  0.0000000000000000, 0.0 },
  { -14.650661983680420, 100, 1, 
	  10.000000000000000, 0.0 },
  { 1626.5010939361582, 100, 1, 
	  20.000000000000000, 0.0 },
  { 417884.77658268728, 100, 1, 
	  30.000000000000000, 0.0 },
  { -55617646.951649837, 100, 1, 
	  40.000000000000000, 0.0 },
  { 884829874.26626217, 100, 1, 
	  50.000000000000000, 0.0 },
  { 154466082750.32202, 100, 1, 
	  60.000000000000000, 0.0 },
  { -101423973484646.00, 100, 1, 
	  70.000000000000000, 0.0 },
  { -1388352348671756.8, 100, 1, 
	  80.000000000000000, 0.0 },
  { 7.8048705513268582e+17, 100, 1, 
	  90.000000000000000, 0.0 },
  { 1.6948925059042755e+19, 100, 1, 
	  100.00000000000000, 0.0 },
};
const double toler058 = 1.0000000000000008e-12;

// Test data for n=100, m=2.
// max(|f - f_GSL|): 557056.00000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 5.1603746667135714e-15
// mean(f - f_GSL): 50294.883489425141
// variance(f - f_GSL): 2009492413242.1035
// stddev(f - f_GSL): 1417565.6645256698
const testcase_assoc_laguerre<double>
data059[11] =
{
  { 5151.0000000000055, 100, 2, 
	  0.0000000000000000, 0.0 },
  { -150.22012290951324, 100, 2, 
	  10.000000000000000, 0.0 },
  { -7655.0593294049449, 100, 2, 
	  20.000000000000000, 0.0 },
  { -140996.69276179091, 100, 2, 
	  30.000000000000000, 0.0 },
  { -38645171.278549351, 100, 2, 
	  40.000000000000000, 0.0 },
  { -8889263688.2118931, 100, 2, 
	  50.000000000000000, 0.0 },
  { -1010338971533.3400, 100, 2, 
	  60.000000000000000, 0.0 },
  { -127582564332943.91, 100, 2, 
	  70.000000000000000, 0.0 },
  { 15970305694654312., 100, 2, 
	  80.000000000000000, 0.0 },
  { -1.6019844992862820e+18, 100, 2, 
	  90.000000000000000, 0.0 },
  { 2.8267024730962955e+20, 100, 2, 
	  100.00000000000000, 0.0 },
};
const double toler059 = 5.0000000000000039e-13;

// Test data for n=100, m=5.
// max(|f - f_GSL|): 393216.00000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 8.0946565190235238e-15
// mean(f - f_GSL): 35883.277835871675
// variance(f - f_GSL): 72845813363.438187
// stddev(f - f_GSL): 269899.63572305575
const testcase_assoc_laguerre<double>
data060[11] =
{
  { 96560646.000000030, 100, 5, 
	  0.0000000000000000, 0.0 },
  { 2430.6732236677612, 100, 5, 
	  10.000000000000000, 0.0 },
  { 111162.32026994647, 100, 5, 
	  20.000000000000000, 0.0 },
  { 4036708.2599413628, 100, 5, 
	  30.000000000000000, 0.0 },
  { -34055982.664405443, 100, 5, 
	  40.000000000000000, 0.0 },
  { 30110688343.562328, 100, 5, 
	  50.000000000000000, 0.0 },
  { 2651429940558.2974, 100, 5, 
	  60.000000000000000, 0.0 },
  { 192108556058943.09, 100, 5, 
	  70.000000000000000, 0.0 },
  { -25410533973455528., 100, 5, 
	  80.000000000000000, 0.0 },
  { 2.1072955633564431e+18, 100, 5, 
	  90.000000000000000, 0.0 },
  { -2.9434005355877289e+20, 100, 5, 
	  100.00000000000000, 0.0 },
};
const double toler060 = 5.0000000000000039e-13;

// Test data for n=100, m=10.
// max(|f - f_GSL|): 155648.00000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 5.1685581852917721e-15
// mean(f - f_GSL): 13707.238286828961
// variance(f - f_GSL): 5037793089646.2549
// stddev(f - f_GSL): 2244502.8602446141
const testcase_assoc_laguerre<double>
data061[11] =
{
  { 46897636623981.039, 100, 10, 
	  0.0000000000000000, 0.0 },
  { 529208.11550990329, 100, 10, 
	  10.000000000000000, 0.0 },
  { 7402892.1748803817, 100, 10, 
	  20.000000000000000, 0.0 },
  { 88369632.083243579, 100, 10, 
	  30.000000000000000, 0.0 },
  { 822187797.59096563, 100, 10, 
	  40.000000000000000, 0.0 },
  { 180231446033.06866, 100, 10, 
	  50.000000000000000, 0.0 },
  { 7922942703798.1309, 100, 10, 
	  60.000000000000000, 0.0 },
  { 784424250559042.12, 100, 10, 
	  70.000000000000000, 0.0 },
  { -16325634720239370., 100, 10, 
	  80.000000000000000, 0.0 },
  { -1.0879588307443162e+18, 100, 10, 
	  90.000000000000000, 0.0 },
  { 3.0114394463610642e+19, 100, 10, 
	  100.00000000000000, 0.0 },
};
const double toler061 = 5.0000000000000039e-13;

// Test data for n=100, m=20.
// max(|f - f_GSL|): 524288.00000000000 at index 10
// max(|f - f_GSL| / |f_GSL|): 3.7005989410347388e-14
// mean(f - f_GSL): -46766.623212640938
// variance(f - f_GSL): 55764004614002920.
// stddev(f - f_GSL): 236144033.61932081
const testcase_assoc_laguerre<double>
data062[11] =
{
  { 2.9462227291176614e+22, 100, 20, 
	  0.0000000000000000, 0.0 },
  { 313694958939.90405, 100, 20, 
	  10.000000000000000, 0.0 },
  { 45396489338.096191, 100, 20, 
	  20.000000000000000, 0.0 },
  { -7215826758.0081253, 100, 20, 
	  30.000000000000000, 0.0 },
  { 825949194005.88855, 100, 20, 
	  40.000000000000000, 0.0 },
  { -2764742119971.0811, 100, 20, 
	  50.000000000000000, 0.0 },
  { -219802198273516.03, 100, 20, 
	  60.000000000000000, 0.0 },
  { -1699053306145262.0, 100, 20, 
	  70.000000000000000, 0.0 },
  { 3.5495709345023846e+17, 100, 20, 
	  80.000000000000000, 0.0 },
  { -9.6128675110292419e+18, 100, 20, 
	  90.000000000000000, 0.0 },
  { 4.3619868422072212e+20, 100, 20, 
	  100.00000000000000, 0.0 },
};
const double toler062 = 2.5000000000000015e-12;

// Test data for n=100, m=50.
// max(|f - f_GSL|): 316659348799488.00 at index 1
// max(|f - f_GSL| / |f_GSL|): 1.1554040570270351e-14
// mean(f - f_GSL): -28787238841995.637
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_laguerre<double>
data063[11] =
{
  { 2.0128660909731931e+40, 100, 50, 
	  0.0000000000000000, 0.0 },
  { -4.0151443913473373e+28, 100, 50, 
	  10.000000000000000, 0.0 },
  { 3.2199632594551924e+22, 100, 50, 
	  20.000000000000000, 0.0 },
  { -2.7568702092659756e+20, 100, 50, 
	  30.000000000000000, 0.0 },
  { 7.5553066015421563e+19, 100, 50, 
	  40.000000000000000, 0.0 },
  { -2.7651625252387734e+19, 100, 50, 
	  50.000000000000000, 0.0 },
  { -5.8963680147283804e+19, 100, 50, 
	  60.000000000000000, 0.0 },
  { -1.8082798163033106e+20, 100, 50, 
	  70.000000000000000, 0.0 },
  { -3.9044276986817249e+20, 100, 50, 
	  80.000000000000000, 0.0 },
  { 6.9926310700401904e+21, 100, 50, 
	  90.000000000000000, 0.0 },
  { -5.5727272809923646e+22, 100, 50, 
	  100.00000000000000, 0.0 },
};
const double toler063 = 1.0000000000000008e-12;

// Test data for n=100, m=100.
// max(|f - f_GSL|): 2.3819765684465692e+39 at index 1
// max(|f - f_GSL| / |f_GSL|): 1.9897039067343855e-14
// mean(f - f_GSL): 2.1654330573519588e+38
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_laguerre<double>
data064[11] =
{
  { 9.0548514656103225e+58, 100, 100, 
	  0.0000000000000000, 0.0 },
  { 1.3334078033060556e+54, 100, 100, 
	  10.000000000000000, 0.0 },
  { 2.1002639254211340e+46, 100, 100, 
	  20.000000000000000, 0.0 },
  { -1.1073158068796292e+39, 100, 100, 
	  30.000000000000000, 0.0 },
  { -8.3640937363981346e+35, 100, 100, 
	  40.000000000000000, 0.0 },
  { -6.5879339429312686e+32, 100, 100, 
	  50.000000000000000, 0.0 },
  { -2.4190645077698771e+30, 100, 100, 
	  60.000000000000000, 0.0 },
  { -7.9224960465662171e+29, 100, 100, 
	  70.000000000000000, 0.0 },
  { -2.8605772478408694e+29, 100, 100, 
	  80.000000000000000, 0.0 },
  { 2.4149589189609957e+28, 100, 100, 
	  90.000000000000000, 0.0 },
  { 5.1146476014859021e+28, 100, 100, 
	  100.00000000000000, 0.0 },
};
const double toler064 = 1.0000000000000008e-12;

template<typename Ret, unsigned int Num>
  void
  test(const testcase_assoc_laguerre<Ret> (&data)[Num], Ret toler)
  {
    bool test __attribute__((unused)) = true;
    const Ret eps = std::numeric_limits<Ret>::epsilon();
    Ret max_abs_diff = -Ret(1);
    Ret max_abs_frac = -Ret(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
  	 {
	const Ret f = std::tr1::assoc_laguerre(data[i].n, data[i].m,
		     data[i].x);
	const Ret f0 = data[i].f0;
	const Ret diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Ret(10) * eps
	 && std::abs(f) > Ret(10) * eps)
	  {
	    const Ret frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  test(data037, toler037);
  test(data038, toler038);
  test(data039, toler039);
  test(data040, toler040);
  test(data041, toler041);
  test(data042, toler042);
  test(data043, toler043);
  test(data044, toler044);
  test(data045, toler045);
  test(data046, toler046);
  test(data047, toler047);
  test(data048, toler048);
  test(data049, toler049);
  test(data050, toler050);
  test(data051, toler051);
  test(data052, toler052);
  test(data053, toler053);
  test(data054, toler054);
  test(data055, toler055);
  test(data056, toler056);
  test(data057, toler057);
  test(data058, toler058);
  test(data059, toler059);
  test(data060, toler060);
  test(data061, toler061);
  test(data062, toler062);
  test(data063, toler063);
  test(data064, toler064);
  return 0;
}
